// AIScanDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AIScan.h"
#include "AIScanDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAIScanDlg dialog

CAIScanDlg::CAIScanDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAIScanDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAIScanDlg)
	m_device = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAIScanDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAIScanDlg)
	DDX_Control(pDX, IDC_LIST1, m_AIListData);
	DDX_Control(pDX, IDC_SCAN, m_scanButton);
	DDX_Text(pDX, IDC_DEVICE, m_device);
	DDV_MinMaxUInt(pDX, m_device, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAIScanDlg, CDialog)
	//{{AFX_MSG_MAP(CAIScanDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INITIALIZE, OnInitialize)
	ON_BN_CLICKED(IDC_SCAN, OnScan)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAIScanDlg message handlers

BOOL CAIScanDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	  m_pSR=NULL;
      m_driverInstance=NULL;
	  m_device = 0;
	  UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAIScanDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAIScanDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAIScanDlg::OnInitialize() 
{
   // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kmb800"); //Open DriverLINX driver
// pass in driver name to avoid the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
UpdateData(TRUE);  // get new data from the dialog for the device number
m_pSR->device=m_device; //set the device number to the device being used
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_scanButton.EnableWindow(TRUE);  // enable the Scan button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}	
CWnd::SetActiveWindow();  // set focus back to our dialog
}

void CAIScanDlg::OnScan() 
{
	// setup a multi channel, polled mode AI task
	m_pSR->mode = POLLED;
	m_pSR->operation = START;
	m_pSR->subsystem = AI;
	m_pSR->start.typeEvent = COMMAND;
	m_pSR->stop.typeEvent = TCEVENT;
	m_pSR->timing.typeEvent = NULLEVENT;  // polled mode has no timing spec
	m_pSR->channels.nChannels = 2;  // a start and a stop channel will be provided
	m_pSR->channels.chanGain[0].channel = 0;  // start chan and gain
	m_pSR->channels.chanGain[0].gainOrRange = Gain2Code(0,AI,-1);
    m_pSR->channels.chanGain[1].channel = 7;  // stop chan and gain
	m_pSR->channels.chanGain[1].gainOrRange = Gain2Code(0,AI,-1);
	// start on 0, stop on 7 = 8 channels in total
	m_pSR->channels.chanGain[0].gainOrRange = Gain2Code(0,AI,-1);
	/*
      The -1 gain means bipolar (negative) gain of 1.
	  The DAS-800 has this range only
	  The DAS-801 or DAS-802 have other gain choices.
    */
	m_pSR->channels.numberFormat = tNATIVE;
	// need a buffer for the data
	// polled mode tasks can scan each channel one time
	// the buffer MUST be a multiple of the channels
	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)]; //create a buffer list pointer for one buffer
	m_pSR->lpBuffers->nBuffers=1; //use only one buffer
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(0,AI,0,8); //set the size of the buffer (in bytes) to hold 8 samples
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_POLLED,m_pSR->lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified
	if (DriverLINX(m_pSR) == NoErr)
	{  // success
	// polled mode tasks operate in the foreground.  Can process
	// the data immediately.  No need to coordinate data processing with 
	// buffer filled messages.  See AIPaced example for message
	// based data processing example.
		done();
	}
    else
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}	
}

void CAIScanDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	// code to clean up after DriverLINX
  clearBuffers();  // de-allocate data buffers
  CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
  m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
  delete(m_pSR); //de-allocate the memory used by the service request
  m_pSR=NULL;
  // pass it on to MFC
	CDialog::OnClose();
}

void CAIScanDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAIScanDlg::done()
{
	float *readings;
	readings = new float[8]; //make a temporary array to hold the converted readings
	CString str; //The CString class includes a format method to convert float to CString to display them in the listbox
	char chanIndex[30];
	int index;
	/*The convert operation used here is taking advantage of the fact
	that the logical device number and the subsystem (AI) have already
	been set in the start request*/
	m_pSR->operation=CONVERT; //Use the convert operation to convert the raw counts in the buffer to voltages
	m_pSR->mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
	m_pSR->start.typeEvent=DATACONVERT; //Set the start type to convert the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
	m_pSR->start.u.dataConvert.nSamples=8; //set the number of samples to convert
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //convert DriverLINX buffer 0, since that's the only one being used
	m_pSR->start.u.dataConvert.lpBuffer=readings; //put the converted readings in the temporary buffer
	DriverLINX(m_pSR); //Execute the conversion
	showMessage(m_pSR); //show any errors
	m_AIListData.ResetContent(); //clear the listbox
	for(index=0;index<8;index++)  // loop through the 8 samples
	{
       strcpy(chanIndex,"chan #: ");
	   str.Format("%d",index);
	   strcat(chanIndex,str);  
       strcat(chanIndex," ");  // build a string of indexed chans
	   str.Format("%8.3f",readings[index]); //format the float reading into a string for each reading
	   strcat(chanIndex,str);  // add the reading onto end
	   m_AIListData.AddString(chanIndex); //Add the string to the listbox
	}
	UpdateData(FALSE); //Update the dialog
	delete [] readings; //clear the temporary buffer so we don't have memory leaks when we run it again

}

void CAIScanDlg::clearBuffers()
{
	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(m_pSR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(m_pSR->lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to
			a buffer?*/
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(m_pSR->lpBuffers); 
			m_pSR->lpBuffers=NULL;
		}
	}
}
